<#ibiztemplate>
TARGET=PSAPPDEUILOGIC
</#ibiztemplate>
<#ibizinclude>
../@MACRO/ui-logic-node.txt
</#ibizinclude>
import { UIActionContext } from "@/logic/ui-logic";
/**
 * ${item.name}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UILogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UILogicBase {

    /**
     * Creates an instance of  ${item.codeName}Base.
     * 
     * @param {*} [opts={}]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 开始节点
     *
     * @protected
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected readonly startLogicNode: string = '<#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>${item.getStartPSDEUILogicNode().codeName}</#if>';

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected logicParams: any[] = [
<#if item.getPSDEUILogicParams?? && item.getPSDEUILogicParams()??>
    <#list item.getPSDEUILogicParams() as logicParam>
        {
            name: '${logicParam.name}',
            codeName: '${logicParam.codeName}',
            activeContainerParam: <#if logicParam.isActiveContainerParam?? && logicParam.isActiveContainerParam()>true<#else>false</#if>,
            activeCtrlParam: <#if logicParam.isActiveCtrlParam?? && logicParam.isActiveCtrlParam()>true<#else>false</#if>,
            activeViewParam: <#if logicParam.isActiveViewParam?? && logicParam.isActiveViewParam()>true<#else>false</#if>,
            appGlobalParam: <#if logicParam.isAppGlobalParam?? && logicParam.isAppGlobalParam()>true<#else>false</#if>,
            applicationParam: <#if logicParam.isApplicationParam?? && logicParam.isApplicationParam()>true<#else>false</#if>,
            ctrlParam: <#if logicParam.isCtrlParam?? && logicParam.isCtrlParam()>true<#else>false</#if>,
            default: <#if logicParam.isDefault?? && logicParam.isDefault()>true<#else>false</#if>,
            entityParam: <#if logicParam.isEntityParam?? && logicParam.isEntityParam()>true<#else>false</#if>,
            entityListParam: <#if logicParam.isEntityListParam?? && logicParam.isEntityListParam()>true<#else>false</#if>,
            entityPageParam: <#if logicParam.isEntityPageParam?? && logicParam.isEntityPageParam()>true<#else>false</#if>,
            filterParam: <#if logicParam.isFilterParam?? && logicParam.isFilterParam()>true<#else>false</#if>,
            navContextParam: <#if logicParam.isNavContextParam?? && logicParam.isNavContextParam()>true<#else>false</#if>,
            simpleParam: <#if logicParam.isSimpleParam?? && logicParam.isSimpleParam()>true<#else>false</#if>,
            simpleListParam: <#if logicParam.isSimpleListParam?? && logicParam.isSimpleListParam()>true<#else>false</#if>,
            routeViewSessionParam: <#if logicParam.isRouteViewSessionParam?? && logicParam.isRouteViewSessionParam()>true<#else>false</#if>,
            viewNavDataParam: <#if logicParam.isViewNavDataParam?? && logicParam.isViewNavDataParam()>true<#else>false</#if>,
            viewSessionParam: <#if logicParam.isViewSessionParam?? && logicParam.isViewSessionParam()>true<#else>false</#if>,
            lastReturnParam: <#if logicParam.isLastReturnParam?? && logicParam.isLastReturnParam()>true<#else>false</#if>
        },
    </#list>
</#if>
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            <#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>
            await this.execute_${item.getStartPSDEUILogicNode().codeName?lower_case}_node(actionContext);
            <#else>
            throw new Error('没有开始节点');
            </#if>
            return actionContext.getResult();
        } catch (error: any) {
            <#noparse>throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);</#noparse>
        }
    }

<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
    <@executenode logicNode/>
    
    </#list>
</#if>

}